// Zoo.java - [static]
//  this is a simple client program, unrealistic,
//  but shows the Show() methods only dealing with
//  the appropriate personality (and its UI)
import java.util.*;
public class Zoo 
{
  static public void main(String args[]) {
    Vector all_swimmers = new Vector();
    Vector all_fliers   = new Vector();
    Vector all_walkers  = new Vector();
    Vector all_jumpers  = new Vector();
    
    // some animals are born in our zoo...
    // notice that the client or the factory 
    // must know what Personalities are attached
    // to each class. 
    SeaLion toto   = new SeaLion(); 
    toto.setName("Toto");
    all_swimmers.addElement( toto );
    all_walkers.addElement( toto );
    all_jumpers.addElement( toto );

    Whale   keiko  = new Whale();   
    keiko.setName("Keiko");
    all_swimmers.addElement( keiko );
    all_jumpers.addElement( keiko );
    
    Bat     drac   = new Bat();     
    drac.setName("Drac");
    all_fliers.addElement( drac );
    
    // perform the different shows
    for(int i=0; i < all_swimmers.size(); i++)
      PoolShow ( (Swimmer)all_swimmers.elementAt(i) );
    for(int i=0; i < all_walkers.size(); i++)
      FieldShow( (Walker)all_walkers.elementAt(i)  );
    for(int i=0; i < all_jumpers.size(); i++)
      JumpShow ( (Jumper)all_jumpers.elementAt(i)  );
    for(int i=0; i < all_fliers.size(); i++)
      SkyShow  ( (Flier)all_fliers.elementAt(i)   );
    
  }

  static void PoolShow(Swimmer swimmer) { 
    System.out.println("  PoolShow with " + swimmer);
    swimmer.Swim( 1, 1 ); 
  }
  static void FieldShow(Walker walker)  {  
    System.out.println("  FieldShow with " + walker);
    walker.Walk( 1 );  
  }
  static void SkyShow(Flier flier)      {  
    System.out.println("  SkyShow with " + flier);
    flier.Fly( 1, 1, 1 );    
  }
  static void JumpShow(Jumper jumper)   {  
    System.out.println("  JumpShow with " + jumper);
    jumper.Jump(1, 1, 1); 
  }
}








