// Zoo.java [dynamic]
//  this is a simple client program, unrealistic,
//  but shows the Show() methods only dealing with
//  the appropriate personality (and its UI)
//  This is the dynamic version of the client, it
//  also does slightly different things.
public class Zoo 
{
  static public void main(String args[]) {
    // some animals are born in our zoo...
    SeaLion toto   = new SeaLion(); toto.setName("Toto");
    Whale   keiko  = new Whale();   keiko.setName("Keiko");
    Bat     drac   = new Bat();     drac.setName("Drac");
    System.out.println("TIME 0 - Zoo is created");

    toto.personify( "Tracer" );
    keiko.personify( "Tracer" );
    drac.personify( "Tracer" );

    pp(toto); pp(keiko); pp(drac);

    // toto and keiko can swim the moment
    // they are born. drac, however, can't fly
    keiko.personify( "Swimmer" );
    toto.personify( "Swimmer" );

    System.out.println("TIME 1 - animals created, Whale and SeaLion swim");
    pp(toto); pp(keiko); pp(drac);

    // they've been just born, but the 
    // show must go on anyways...
    PerformShow( toto  );
    PerformShow( keiko );
    PerformShow( drac  );

    
    // let's pretend time goes on. toto and 
    // keiko are getting strong enough to jump
    // also, drac can now fly
    toto.personify( "Jumper" );
    keiko.personify( "Jumper" );
    drac.personify( "Flier" );

    System.out.println("TIME 2 - Whale and SeaLion jump, Bat flies");
    pp(toto); pp(keiko); pp(drac);
    PerformShow( toto );
    PerformShow( keiko );
    PerformShow( drac );

    // finally, toto can also walk...
    toto.personify( "Walker" );

    System.out.println("TIME 3 - SeaLion walks");
    pp(toto);
    PerformShow( toto );

    // time goes on, and toto and keiko get old, not
    // strong enough to walk or jump anymore
    toto.forget( "Walker" ); 
    toto.forget( "Jumper" );
    keiko.forget( "Jumper" );
    System.out.println("TIME 4 - Whale and SeaLion forget to walk and jump");
    pp(toto); pp(keiko); pp(drac);
    PerformShow( toto );
    PerformShow( keiko );
    PerformShow(drac);
  }

  // master of ceremonies...
  static void PerformShow(Animal animal) {
    System.out.println(" PerformShow with " + animal);
    if ( animal.personifies( "Swimmer" ) )
      PoolShow( (Swimmer)animal );
    if ( animal.personifies( "Walker" ) )
      FieldShow( (Walker)animal );
    if ( animal.personifies( "Flier" ) )
      SkyShow( (Flier)animal );
    if ( animal.personifies( "Jumper" ) )
      JumpShow( (Jumper)animal );
  }
  static void PoolShow(Swimmer swimmer) { 
    System.out.println("  PoolShow with " + swimmer);
    swimmer.Swim( 1, 1 ); 
  }
  static void FieldShow(Walker walker)  {  
    System.out.println("  FieldShow with " + walker);
    walker.Walk( 1 );  
  }
  static void SkyShow(Flier flier)      {  
    System.out.println("  SkyShow with " + flier);
    flier.Fly( 1, 1, 1 );    
  }
  static void JumpShow(Jumper jumper)   {  
    System.out.println("  JumpShow with " + jumper);
    jumper.Jump(1, 1, 1); 
  }
  // auxiliary function
  static void pp(Animal a) {
    System.out.println( a.getName() + ": " + a.personalities() );
  }

}

