// Shrink.java [dynamic]
//  this class is only generated when the 
//  Personalities/J compiler is generating
//  dynamic personalities code. It is a
//  fixed implementation of a helper class
//  used to maintain the personality list
//  for the classes within a particular 
//  inheritance hierarchy.
import java.util.*;
public class Shrink
{
  Vector names  = new Vector();
  Vector states = new Vector();
  
  public void register_personality(String p) {
    if ( ! names.contains(p) ) {
      names.addElement( p );
      states.addElement( Boolean.FALSE ); 
    }
  }
  public boolean personify(String p) {
    if ( !canpersonify(p) ) return false;
    int idx = names.indexOf(p);
    states.setElementAt(Boolean.TRUE, idx);
    return true;
  }
  public boolean forget(String p) {
    if ( !canpersonify(p) ) return false;
    int idx = names.indexOf(p);
    states.setElementAt(Boolean.FALSE, idx);
    return true;
  }
  public boolean personifies(String p) {
    if ( names.contains(p) ) {
      int idx = names.indexOf(p);
      return ((Boolean)
              states.elementAt(idx))
              .booleanValue();
    }
    else return false;
  }
  public boolean canpersonify(String p) {
    return names.contains(p);
  }
  public Vector personalities() { 
    Vector result = new Vector();
    for (int i = 0; i < names.size(); i++) 
      if ( ((Boolean)states.elementAt(i)).booleanValue() )
	result.addElement( names
                           .elementAt(i) );
    return result;
  }
}

